//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import "private"

UiSpinBoxBase {
    id : uiSpinBox

    Rectangle {
        id : background

        anchors.fill : parent
        z            : -1
        border {
            width : 1
            color : UiColors.getColor(UiColors.ControlGrey20)
        }

        states : [
            State {
                name : "disabled"
                when : uiSpinBox.disabled

                PropertyChanges {
                    target       : background
                    border.color : UiColors.getColor(
                                       UiColors.DisabledLightGrey13)
                }
            },
            State {
                name : "focus"
                when : activeFocus

                PropertyChanges {
                    target       : background
                    border.color : UiColors.getColor(UiColors.SelectionGreen)
                }
            },
            State {
                name : "hover"
                when : uiSpinBox.hovered

                PropertyChanges {
                    target       : background
                    border.color : UiColors.getColor(UiColors.HoverGreen)
                }
            }
        ]
    }
}
